/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.LootStashDetectorHandler;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class StashDetectorModel
extends Model {
    private static final int DIODE_LIGHT = LightTexture.func_228451_a_((int)15, (int)15);
    private static final int DISPLAY_LIGHT = LightTexture.func_228451_a_((int)13, (int)13);
    private final ModelRenderer red_light;
    private final ModelRenderer bone;
    private final ModelRenderer yellow_light;
    private final ModelRenderer bone5;
    private final ModelRenderer green_light;
    private final ModelRenderer bone6;
    private final ModelRenderer light_support;
    private final ModelRenderer bone2;
    private final ModelRenderer light_support2;
    private final ModelRenderer bone3;
    private final ModelRenderer light_support3;
    private final ModelRenderer bone4;
    private final ModelRenderer display;
    private final ModelRenderer cube_r1;
    private final ModelRenderer base;
    private final ModelRenderer bone11;
    private final ModelRenderer bone12;
    private final ModelRenderer bone13;
    private final ModelRenderer cube_r2;
    private final ModelRenderer bone14;
    private final ModelRenderer cube_r3;
    private final ModelRenderer keypad;
    private final ModelRenderer battery;
    private final ModelRenderer bone7;
    private final ModelRenderer battery_cover;
    private final ModelRenderer bone8;
    private final ModelRenderer bone9;
    private final ModelRenderer bone10;
    private final Map<LootStashDetectorHandler.Status, ModelRenderer> statusMap = new EnumMap<LootStashDetectorHandler.Status, ModelRenderer>(LootStashDetectorHandler.Status.class);

    private void renderLights(MatrixStack stack, IVertexBuilder builder, int light, int overlay) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        UUID uuid = player.func_110124_au();
        if (LootStashDetectorHandler.isUsing(uuid)) {
            this.keypad.func_228308_a_(stack, builder, DISPLAY_LIGHT, overlay);
            this.display.func_228308_a_(stack, builder, DISPLAY_LIGHT, overlay);
            LootStashDetectorHandler.DetectionData data = LootStashDetectorHandler.getData(uuid);
            LootStashDetectorHandler.Status status = data.getStatus();
            for (Map.Entry<LootStashDetectorHandler.Status, ModelRenderer> entry : this.statusMap.entrySet()) {
                if (entry.getKey() == status) {
                    int lightValue = DIODE_LIGHT;
                    if (status == LootStashDetectorHandler.Status.NEARBY) {
                        int value = (int)(data.getDiodeIntesity() * 15.0f);
                        lightValue = LightTexture.func_228451_a_((int)value, (int)value);
                    }
                    entry.getValue().func_228308_a_(stack, builder, lightValue, overlay);
                    continue;
                }
                entry.getValue().func_228308_a_(stack, builder, 0, overlay);
            }
        } else {
            this.statusMap.values().forEach(renderer -> renderer.func_228308_a_(stack, builder, 0, overlay));
            this.keypad.func_228308_a_(stack, builder, 0, overlay);
            this.display.func_228308_a_(stack, builder, 0, overlay);
        }
    }

    public void renderStashDetector(MatrixStack stack, IRenderTypeBuffer typeBuffer, IVertexBuilder builder, int light, int overlay, ItemCameraTransforms.TransformType type) {
        this.light_support.func_228308_a_(stack, builder, light, overlay);
        this.light_support2.func_228308_a_(stack, builder, light, overlay);
        this.light_support3.func_228308_a_(stack, builder, light, overlay);
        this.base.func_228308_a_(stack, builder, light, overlay);
        this.renderLights(stack, builder, light, overlay);
        this.renderAnimatable(stack, typeBuffer, builder, light, overlay, type.func_241716_a_());
    }

    private void renderAnimatable(MatrixStack stack, IRenderTypeBuffer typeBuffer, IVertexBuilder builder, int light, int overlay, boolean shouldAnimate) {
        if (shouldAnimate) {
            IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
            stack.func_227860_a_();
            pipeline.animateStage(ModAnimations.BATTERY, stack, typeBuffer, light, overlay);
            this.battery.func_228308_a_(stack, builder, light, overlay);
            stack.func_227865_b_();
            stack.func_227860_a_();
            pipeline.animateStage(ModAnimations.BATTERY_COVER, stack, typeBuffer, light, overlay);
            this.battery_cover.func_228308_a_(stack, builder, light, overlay);
            stack.func_227865_b_();
        } else {
            this.battery.func_228308_a_(stack, builder, light, overlay);
            this.battery_cover.func_228308_a_(stack, builder, light, overlay);
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int light, int overlay, float red, float green, float blue, float alpha) {
        throw new UnsupportedOperationException();
    }

    public StashDetectorModel() {
        super(RenderType::func_228634_a_);
        this.field_78090_t = 512;
        this.field_78089_u = 512;
        this.red_light = new ModelRenderer((Model)this);
        this.red_light.func_78793_a(-0.3f, 12.9f, 0.5f);
        this.red_light.func_78784_a(427, 174).func_228303_a_(-6.2f, -2.9858f, 6.6f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.red_light.func_78784_a(427, 174).func_228303_a_(-6.2f, -3.6929f, 7.3071f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.red_light.func_78784_a(427, 174).func_228303_a_(-6.2f, -3.6929f, 5.8929f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.red_light.func_78784_a(427, 174).func_228303_a_(-6.2f, -4.4f, 6.6f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.bone = new ModelRenderer((Model)this);
        this.bone.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.red_light.func_78792_a(this.bone);
        StashDetectorModel.setRotationAngle(this.bone, -0.7854f, 0.0f, 0.0f);
        this.bone.func_78784_a(427, 174).func_228303_a_(-5.7f, 28.2843f, 72.2663f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone.func_78784_a(427, 174).func_228303_a_(-5.7f, 28.2843f, 70.8521f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone.func_78784_a(427, 174).func_228303_a_(-5.7f, 28.9914f, 71.5592f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone.func_78784_a(427, 174).func_228303_a_(-5.7f, 27.5772f, 71.5592f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.yellow_light = new ModelRenderer((Model)this);
        this.yellow_light.func_78793_a(-0.3f, 12.9f, -7.925f);
        this.yellow_light.func_78784_a(357, 241).func_228303_a_(-6.2f, -2.9858f, 7.5f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.yellow_light.func_78784_a(357, 241).func_228303_a_(-6.2f, -3.6929f, 8.2071f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.yellow_light.func_78784_a(357, 241).func_228303_a_(-6.2f, -3.6929f, 6.7929f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.yellow_light.func_78784_a(357, 241).func_228303_a_(-6.2f, -4.4f, 7.5f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.bone5 = new ModelRenderer((Model)this);
        this.bone5.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.yellow_light.func_78792_a(this.bone5);
        StashDetectorModel.setRotationAngle(this.bone5, -0.7854f, 0.0f, 0.0f);
        this.bone5.func_78784_a(357, 241).func_228303_a_(-5.7f, 27.6479f, 72.9027f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone5.func_78784_a(357, 241).func_228303_a_(-5.7f, 27.6479f, 71.4885f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone5.func_78784_a(357, 241).func_228303_a_(-5.7f, 28.355f, 72.1956f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone5.func_78784_a(357, 241).func_228303_a_(-5.7f, 26.9408f, 72.1956f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.green_light = new ModelRenderer((Model)this);
        this.green_light.func_78793_a(-0.3f, 12.9f, -16.1f);
        this.green_light.func_78784_a(237, 215).func_228303_a_(-6.2f, -2.9858f, 8.1f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.green_light.func_78784_a(237, 215).func_228303_a_(-6.2f, -3.6929f, 8.8071f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.green_light.func_78784_a(237, 215).func_228303_a_(-6.2f, -3.6929f, 7.3929f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.green_light.func_78784_a(237, 215).func_228303_a_(-6.2f, -4.4f, 8.1f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.bone6 = new ModelRenderer((Model)this);
        this.bone6.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.green_light.func_78792_a(this.bone6);
        StashDetectorModel.setRotationAngle(this.bone6, -0.7854f, 0.0f, 0.0f);
        this.bone6.func_78784_a(237, 215).func_228303_a_(-5.7f, 27.2236f, 73.327f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone6.func_78784_a(237, 215).func_228303_a_(-5.7f, 27.2236f, 71.9128f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone6.func_78784_a(237, 215).func_228303_a_(-5.7f, 27.9307f, 72.6199f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.bone6.func_78784_a(237, 215).func_228303_a_(-5.7f, 26.5165f, 72.6199f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.light_support = new ModelRenderer((Model)this);
        this.light_support.func_78793_a(0.0f, 17.3f, 4.2f);
        this.light_support.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 3.7716f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support.func_78784_a(342, 168).func_228303_a_(-6.0f, -10.0569f, 2.3574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 0.9431f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support.func_78784_a(342, 168).func_228303_a_(-6.0f, -7.2284f, 2.3574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone2 = new ModelRenderer((Model)this);
        this.bone2.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.light_support.func_78792_a(this.bone2);
        StashDetectorModel.setRotationAngle(this.bone2, -0.7854f, 0.0f, 0.0f);
        this.bone2.func_78784_a(342, 168).func_228303_a_(-5.5f, 27.2843f, 66.6805f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone2.func_78784_a(342, 168).func_228303_a_(-5.5f, 27.2843f, 63.8521f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.bone2.func_78784_a(342, 168).func_228303_a_(-5.5f, 28.6985f, 65.2663f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone2.func_78784_a(342, 168).func_228303_a_(-5.5f, 25.8701f, 65.2663f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support2 = new ModelRenderer((Model)this);
        this.light_support2.func_78793_a(0.0f, 17.3f, -12.4f);
        this.light_support2.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 5.2716f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support2.func_78784_a(342, 168).func_228303_a_(-6.0f, -10.0569f, 3.8574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support2.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 2.4431f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support2.func_78784_a(342, 168).func_228303_a_(-6.0f, -7.2284f, 3.8574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone3 = new ModelRenderer((Model)this);
        this.bone3.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.light_support2.func_78792_a(this.bone3);
        StashDetectorModel.setRotationAngle(this.bone3, -0.7854f, 0.0f, 0.0f);
        this.bone3.func_78784_a(342, 168).func_228303_a_(-5.5f, 26.2236f, 67.7412f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone3.func_78784_a(342, 168).func_228303_a_(-5.5f, 26.2236f, 64.9128f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.bone3.func_78784_a(342, 168).func_228303_a_(-5.5f, 27.6378f, 66.327f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone3.func_78784_a(342, 168).func_228303_a_(-5.5f, 24.8094f, 66.327f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support3 = new ModelRenderer((Model)this);
        this.light_support3.func_78793_a(0.0f, 17.3f, -4.2f);
        this.light_support3.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 4.6716f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support3.func_78784_a(342, 168).func_228303_a_(-6.0f, -10.0569f, 3.2574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support3.func_78784_a(342, 168).func_228303_a_(-6.0f, -8.6426f, 1.8431f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.light_support3.func_78784_a(342, 168).func_228303_a_(-6.0f, -7.2284f, 3.2574f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone4 = new ModelRenderer((Model)this);
        this.bone4.func_78793_a(-0.5f, -74.5f, -23.5f);
        this.light_support3.func_78792_a(this.bone4);
        StashDetectorModel.setRotationAngle(this.bone4, -0.7854f, 0.0f, 0.0f);
        this.bone4.func_78784_a(342, 168).func_228303_a_(-5.5f, 26.6479f, 67.3169f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone4.func_78784_a(342, 168).func_228303_a_(-5.5f, 26.6479f, 64.4885f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.bone4.func_78784_a(342, 168).func_228303_a_(-5.5f, 28.0621f, 65.9027f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.bone4.func_78784_a(342, 168).func_228303_a_(-5.5f, 25.2337f, 65.9027f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.display = new ModelRenderer((Model)this);
        this.display.func_78793_a(0.0f, 24.0f, 0.0f);
        this.cube_r1 = new ModelRenderer((Model)this);
        this.cube_r1.func_78793_a(-5.4f, -21.5f, 0.0f);
        this.display.func_78792_a(this.cube_r1);
        StashDetectorModel.setRotationAngle(this.cube_r1, 1.5708f, 0.0f, 0.0f);
        this.cube_r1.func_78784_a(360, 141).func_228303_a_(-0.5f, -9.5f, -3.0f, 1.0f, 19.0f, 6.0f, 0.0f, false);
        this.base = new ModelRenderer((Model)this);
        this.base.func_78793_a(0.0f, 24.0f, 0.0f);
        this.base.func_78784_a(401, 133).func_228303_a_(-5.8f, -26.0f, 0.0f, 11.0f, 19.0f, 12.0f, 0.0f, false);
        this.base.func_78784_a(401, 133).func_228303_a_(-3.7f, -14.6f, 11.5f, 6.0f, 11.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(401, 135).func_228303_a_(-5.8f, -7.0f, 0.0f, 11.0f, 14.0f, 12.0f, 0.0f, false);
        this.base.func_78784_a(401, 135).func_228303_a_(-5.8f, -7.0f, -12.0f, 11.0f, 14.0f, 12.0f, 0.0f, false);
        this.base.func_78784_a(401, 133).func_228303_a_(-5.8f, -26.0f, -12.0f, 11.0f, 19.0f, 12.0f, 0.0f, false);
        this.base.func_78784_a(401, 133).func_228303_a_(-2.6f, -26.8f, -11.0f, 4.0f, 1.0f, 5.0f, 0.0f, false);
        this.base.func_78784_a(401, 133).func_228303_a_(-2.6f, -26.8f, -1.0f, 4.0f, 1.0f, 11.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -10.4f, -10.0f, 1.0f, 16.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -9.4f, 2.8f, 1.0f, 14.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -9.4f, -3.7f, 1.0f, 14.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -10.4f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(157, 18).func_228303_a_(-6.1f, -25.0f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(157, 18).func_228303_a_(-6.1f, -19.0f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -5.4f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.1f, -0.4f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.1f, 4.6f, -9.0f, 1.0f, 1.0f, 18.0f, 0.0f, false);
        this.base.func_78784_a(406, 135).func_228303_a_(-6.0f, -10.4f, 9.0f, 1.0f, 16.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(157, 18).func_228303_a_(-6.1f, -25.0f, -10.0f, 1.0f, 7.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(157, 18).func_228303_a_(-6.1f, -25.0f, 9.0f, 1.0f, 7.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(407, 143).func_228303_a_(-5.8f, 7.0f, 10.0f, 10.0f, 13.0f, 2.0f, 0.0f, false);
        this.base.func_78784_a(415, 144).func_228303_a_(-5.8f, 7.0f, -12.0f, 10.0f, 13.0f, 2.0f, 0.0f, false);
        this.base.func_78784_a(395, 138).func_228303_a_(-4.8f, 17.0f, -10.0f, 9.0f, 3.0f, 20.0f, 0.0f, false);
        this.base.func_78784_a(399, 129).func_228303_a_(4.2f, 7.0f, -12.0f, 1.0f, 13.0f, 24.0f, 0.0f, false);
        this.bone11 = new ModelRenderer((Model)this);
        this.bone11.func_78793_a(0.0f, 0.0f, 0.0f);
        this.base.func_78792_a(this.bone11);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.2071f, -45.0f, -8.2929f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(157, 235).func_228303_a_(-1.2071f, -45.0f, -9.7071f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-0.5f, -45.0f, -9.0f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.9142f, -45.0f, -9.0f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.2071f, -38.0f, 1.7071f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(157, 235).func_228303_a_(-1.2071f, -38.0f, 0.2929f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-0.5f, -38.0f, 1.0f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.9142f, -38.0f, 1.0f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.2071f, -36.0f, 7.7071f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(157, 235).func_228303_a_(-1.2071f, -36.0f, 6.2929f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-0.5f, -36.0f, 7.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone11.func_78784_a(156, 235).func_228303_a_(-1.9142f, -36.0f, 7.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone12 = new ModelRenderer((Model)this);
        this.bone12.func_78793_a(8.5f, -108.5f, -0.25f);
        this.base.func_78792_a(this.bone12);
        StashDetectorModel.setRotationAngle(this.bone12, 0.0f, 0.7854f, 0.0f);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-1.1768f, 63.5f, -12.1369f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-1.1768f, 63.5f, -13.5511f, 1.0f, 19.0f, 2.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-0.4697f, 63.5f, -12.844f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-1.8839f, 63.5f, -12.844f, 1.0f, 19.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-8.2478f, 70.5f, -5.0659f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-8.2478f, 70.5f, -6.4801f, 1.0f, 12.0f, 2.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-7.5407f, 70.5f, -5.773f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-8.955f, 70.5f, -5.773f, 1.0f, 12.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-12.4905f, 72.5f, -0.8232f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-12.4905f, 72.5f, -2.2374f, 1.0f, 10.0f, 2.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-11.7834f, 72.5f, -1.5303f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone12.func_78784_a(156, 235).func_228303_a_(-13.1976f, 72.5f, -1.5303f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.bone13 = new ModelRenderer((Model)this);
        this.bone13.func_78793_a(0.0f, 0.0f, 0.0f);
        this.base.func_78792_a(this.bone13);
        this.cube_r2 = new ModelRenderer((Model)this);
        this.cube_r2.func_78793_a(-0.1f, -11.5f, 13.0f);
        this.bone13.func_78792_a(this.cube_r2);
        StashDetectorModel.setRotationAngle(this.cube_r2, -0.2182f, 0.0f, 0.0f);
        this.cube_r2.func_78784_a(181, 237).func_228303_a_(-2.5f, -1.5f, -1.5f, 4.0f, 5.0f, 2.0f, 0.0f, false);
        this.bone14 = new ModelRenderer((Model)this);
        this.bone14.func_78793_a(0.0f, 0.0f, 0.0f);
        this.base.func_78792_a(this.bone14);
        this.cube_r3 = new ModelRenderer((Model)this);
        this.cube_r3.func_78793_a(-0.1f, -6.5f, 13.0f);
        this.bone14.func_78792_a(this.cube_r3);
        StashDetectorModel.setRotationAngle(this.cube_r3, 0.2182f, 0.0f, 0.0f);
        this.cube_r3.func_78784_a(181, 237).func_228303_a_(-2.5f, -3.7f, -1.4f, 4.0f, 5.0f, 2.0f, 0.0f, false);
        this.keypad = new ModelRenderer((Model)this);
        this.keypad.func_78793_a(0.0f, 24.0f, 0.0f);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -9.4f, -9.7f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -9.4f, -3.25f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -9.4f, 3.1f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -4.4f, 3.1f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -4.4f, -3.25f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, -4.4f, -9.7f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, 0.6f, -9.7f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, 0.6f, -3.25f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.keypad.func_78784_a(370, 160).func_228303_a_(-6.3f, 0.6f, 3.1f, 1.0f, 4.0f, 6.0f, 0.0f, false);
        this.battery = new ModelRenderer((Model)this);
        this.battery.func_78793_a(0.0f, 2.2f, 0.0f);
        this.battery.func_78784_a(143, 18).func_228303_a_(-4.9213f, 32.1213f, -9.5f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.battery.func_78784_a(143, 18).func_228303_a_(-0.6787f, 32.1213f, -9.5f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.battery.func_78784_a(143, 18).func_228303_a_(-2.8f, 30.0f, -9.5f, 3.0f, 4.0f, 14.0f, 0.0f, false);
        this.battery.func_78784_a(143, 18).func_228303_a_(-2.8f, 33.2426f, -9.5f, 3.0f, 4.0f, 14.0f, 0.0f, false);
        this.battery.func_78784_a(436, 246).func_228303_a_(-0.6787f, 32.1213f, 4.5f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.battery.func_78784_a(436, 246).func_228303_a_(-2.8f, 30.0f, 4.5f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.battery.func_78784_a(436, 246).func_228303_a_(-2.8f, 34.2426f, 4.5f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.battery.func_78784_a(436, 246).func_228303_a_(-4.9213f, 32.1213f, 4.5f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.bone7 = new ModelRenderer((Model)this);
        this.bone7.func_78793_a(3.75f, -35.25f, 6.5f);
        this.battery.func_78792_a(this.bone7);
        StashDetectorModel.setRotationAngle(this.bone7, 0.0f, 0.0f, 0.7854f);
        this.bone7.func_78784_a(143, 18).func_228303_a_(41.5072f, 50.7703f, -16.0f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.bone7.func_78784_a(143, 18).func_228303_a_(45.7498f, 50.7703f, -16.0f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.bone7.func_78784_a(143, 18).func_228303_a_(43.6285f, 48.6489f, -16.0f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.bone7.func_78784_a(143, 18).func_228303_a_(43.6285f, 52.8916f, -16.0f, 3.0f, 3.0f, 14.0f, 0.0f, false);
        this.bone7.func_78784_a(436, 246).func_228303_a_(43.6285f, 48.6489f, -2.0f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.bone7.func_78784_a(436, 246).func_228303_a_(41.5072f, 50.7703f, -2.0f, 4.0f, 3.0f, 5.0f, 0.0f, false);
        this.bone7.func_78784_a(436, 246).func_228303_a_(44.7498f, 50.7703f, -2.0f, 4.0f, 3.0f, 5.0f, 0.0f, false);
        this.bone7.func_78784_a(436, 246).func_228303_a_(43.6285f, 52.8916f, -2.0f, 3.0f, 3.0f, 5.0f, 0.0f, false);
        this.battery_cover = new ModelRenderer((Model)this);
        this.battery_cover.func_78793_a(40.3f, 24.0f, 0.0f);
        this.battery_cover.func_78784_a(400, 130).func_228303_a_(-45.6f, 7.0f, -10.0f, 1.0f, 13.0f, 20.0f, 0.0f, false);
        this.bone8 = new ModelRenderer((Model)this);
        this.bone8.func_78793_a(-40.3f, -56.5f, 8.0f);
        this.battery_cover.func_78792_a(this.bone8);
        StashDetectorModel.setRotationAngle(this.bone8, 0.0f, 0.0f, -0.7854f);
        this.bone8.func_78784_a(359, 0).func_228303_a_(-50.5632f, 42.7749f, -13.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
        this.bone9 = new ModelRenderer((Model)this);
        this.bone9.func_78793_a(-40.3f, -57.5f, 8.0f);
        this.battery_cover.func_78792_a(this.bone9);
        StashDetectorModel.setRotationAngle(this.bone9, 0.0f, 0.0f, -0.7854f);
        this.bone9.func_78784_a(359, 0).func_228303_a_(-50.5632f, 42.7749f, -13.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
        this.bone10 = new ModelRenderer((Model)this);
        this.bone10.func_78793_a(-40.3f, -55.5f, 8.0f);
        this.battery_cover.func_78792_a(this.bone10);
        StashDetectorModel.setRotationAngle(this.bone10, 0.0f, 0.0f, -0.7854f);
        this.bone10.func_78784_a(359, 0).func_228303_a_(-50.5632f, 42.7749f, -13.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
        this.statusMap.put(LootStashDetectorHandler.Status.UNDETECTED, this.red_light);
        this.statusMap.put(LootStashDetectorHandler.Status.NEARBY, this.yellow_light);
        this.statusMap.put(LootStashDetectorHandler.Status.LOCATED, this.green_light);
    }

    private static void setRotationAngle(ModelRenderer renderer, float x, float y, float z) {
        renderer.field_78795_f = x;
        renderer.field_78796_g = y;
        renderer.field_78808_h = z;
    }
}

